<!--
*******************************************************************
*                        Melissa Data Corp.                       *
*                        AddressObjectPHPSample.php         	*
*                        							*
*                        Use: libmdAddrPHP.so   			*
*                                       					*
*                        10/28/2004                               *
*******************************************************************
-->
<html>
<head>
<title>Address Object Online Demo 2</title>
<meta http-==uiv="Content-Type" content="text/html; charset=iso-8859-1">
</head>
<?php
//Set License String Here
$license="license here";
$datafiles="path to mdAddr.dat, mdAddr.nat, mdAddr.str, mdAddr.lic";
//getting information
$id=0;
$company="";
$address="";
$city="";
$state="";
$zipcode="";	

if(!empty($_POST))
{
	$id = addslashes($_POST['id']);
	$company = addslashes($_POST['company']);
	$address = addslashes($_POST['address']);
	$city = addslashes($_POST['city']);
	$state = addslashes($_POST['state']);
	$zipcode = addslashes($_POST['zipcode']);
}
?>
<?php
if (!extension_loaded('mdAddrPHP')) {
   if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
       dl('mdAddrPHP.dll');
   } else {
       dl('libmdAddrPHP.so');
   }
}

/* Input	: TimeZoneCode from mdAddrGetTimeZoneCode() function
    Output	: (mm/dd/ccyy hh:mm:ss) format*/
function dateAdd($timezonecode)
{
	$today = getdate();
     	$hour = $today['hours'] + (8 - intval($timezonecode));
	
	$mydate = date("m-d-Y H:i:s ",mktime($hour,$today['minutes'],$today['seconds'],
					$today['mon'],$today['mday'],$today['year']));
	return $mydate;	
}

function writeOutputLine()
{
	echo"<tr>";
	echo"<table width=\"752\" cellspacing=\"0\" border=\"0\" bgcolor=\"#F7F7F7\" align=\"center\">";
	echo"  <tr> ";
	echo"    <td width=\"750\" colspan=\"23\"><font color=\"#ce0000\" size=\"+1\">Output</font></td>";
	echo"  </tr>";
	echo"</table>";
	echo "</tr>";
}
?>
<?php
if ($id==7)
{
	$id = "";
	$company = "";
	$address = "";
	$city = "";
	$state = "";
	$zipcode = "";
}
?>
<?php
/* ****************** ADDRESS CHECK ***************
Using AddressCheck Interface to verify input adress
Methods Used: VerifyAddress Method, ClearProperties, StatusCode, ErrorCode, ErrorString
*************************************************** */
function checkadress($license,$datafiles,$company,$address,$city,$state,$zipcode)
{
	$errorstr="";
	if ( (strlen($zipcode) == 0) & (  (strlen($city) == 0) || (strlen($state) == 0) ) )
	{
		$errorstr = "ZIP Code or City & State Missing";
	}
	else
	{
		if (strlen($address) == 0)
		{
			$errorstr = "Address Line blank";
		}
		else
		{
			// Clear address object properties
			mdAddrClearProperties();
			//Create mdAddress Object
			mdAddrCreate();
			//Set Master License String
		
			mdAddrSetLicenseString($license);

			// Initialize data paths
			mdAddrSetPathToUSFiles($datafiles);
			//mdAddrSetPathToDPVDFiles("PathtoDPVFiles");

			if(mdAddrInitializedataFiles() !=0)
			{
				$errorstr = mdAddrGetInitializeErrorString(); 
			}
		}
	}

	if ($errorstr!="")
	{
		echo "<table width=\"755\" cellspacing=\"2\" border=\"1\" bgcolor=\"#F7F7F7\" align=\"center\">";
        	echo "  <tr align=center>";
        	echo "    <td width=\"745\" colspan=\"2\" bgcolor=\"33ff99\"><div align=\"center\"><b>".$errorstr."</b></div></td> ";
        	echo "  </tr>";
        	echo "</table>";
	}	
	else
	{	
		// set the value			
		mdAddrSetCompany($company);
		mdAddrSetAddress($address);
		mdAddrSetCity($city);
		mdAddrSetState($state);
		mdAddrSetZip($zipcode);
	
		$result = mdAddrVerifyAddress();
		switch (mdAddrGetStatusCode())
		{
			case "9":
				$status = "Address Verified to ZIP+4";
				break;
			case "7":
				$status = "Address Verified to Carrier Route";
				break;
			case "5":
				$status = "Address Verified to 5-digit ZIP Code";
				break;
			case "S":
				$status = "Address Standardized Only";
				break;
			case "X":
				$status = "Address Not Verified";
				break;
			case "D":
				$status = "Demo Mode";
				break;
			case "E":
				$status = "Expired Database";
				break;
			default:
				$status = "Other Status=" .mdAddrGetStatusCode();
				break;
		}

		//draw table
		echo "<table bgcolor=\"FFFFCC\" border=\"1\" cellpadding=\"2\" width=\"754\" align=\"center\">"; 
		echo "<tr align=center> ";
		echo "  <td bgcolor=\"33ff99\" colspan=\"2\"><b>Verify Address</b></td> ";
		echo "</tr> ";
		echo "<tr>  ";
		echo "  <td width=\"363\" align=\"right\">Address Status Code</td> ";
		echo "  <td width=\"371\" align=\"left\"><b>".$status."</b></td>";
		echo "</tr> ";
	
		if ((mdAddrGetStatusCode() == "9") || (mdAddrGetStatusCode() == "7") || (mdAddrGetStatusCode() == "5") || (mdAddrGetStatusCode() == "V"))
		//sif ($result==1)
		{
			if (mdAddrGetDefaultFlagIndicator() == "Y")
			{
				echo "<tr> ";
				echo "<td bgcolor=\"cyan\" colspan=\"2\" align=\"center\"><b>"."Note: Input Apt or Suite number is missing or incorrect.  Matched to default ZIP+4."."</b></td>";
				echo "</tr> ";
			}
			// Company
			if (mdAddrGetCompany() != "")
			{
			?>
			  <tr> 
				<td align=right>Company</td>
				<td><strong><?php echo mdAddrGetCompany() ?></strong></td>
			  </tr>
			<?php
			}
			?>
			  <tr> 
				<td align=right>Street</td>
				<td><b><?php echo mdAddrGetAddress()." ".mdAddrGetSuite() ;?></b></td>
			  </tr>
			  <tr> 
				<td align=right>City, State ZIP+4 Code</td>
				<td><b><?php echo trim(mdAddrGetCity()).", ".mdAddrGetState()." ".mdAddrGetZip()."-".mdAddrGetPlus4(); ?></b></td>
			  </tr>
			<?php
			if (mdAddrGetCarrierRoute()!="")
			{
			?>
			  <tr> 
				<td align=right>Carrier Route</td>
				<td><strong><?php echo mdAddrGetCarrierRoute() ;?></strong></td>
			  </tr>
			<?php
			}
			if (mdAddrGetDeliveryPointCode()!="")
			{
			?>
			  <tr> 
				<td align=right>Delivery Point Code</td>
				<td><strong><?php echo mdAddrGetDeliveryPointCode()."".mdAddrGetDeliveryPointCheckDigit() ;?></strong></td>
			  </tr>
			<?php
			}
			?>
			  <tr> 
				<td align=right>County Name (FIPS Code)</td>
				<td><strong><?php echo (mdAddrGetCountyName()." (".mdAddrGetCountyFips().")");?></strong></td>
			  </tr>
			<?php
			if (mdAddrGetTimeZone()!="")
			{
			?>
			  <tr> 
				<td align=right>Time Zone</td>
				<td><strong><?php echo mdAddrGetTimeZone()." ".dateAdd(mdAddrGetTimeZoneCode()); ?> </strong></td>
			  </tr>
			<?php
			}
			if (mdAddrGetMsa()!="")
			{
			?>
			  <tr> 
				<td align=right>MSA Code</td>
				<td><strong><?php echo mdAddrGetMsa(); ?> </strong></td>
			  </tr>
			<?php
			}
			if (mdAddrGetPmsa()!="")
			{
			?>
			  <tr> 
				<td align=right>PMSA Code</td>
				<td><strong><?php echo mdAddrGetPmsa(); ?> </strong></td>
			  </tr>
			<?php
			}
			if (mdAddrGetAddressTypeString()!="")
			{
			?>
			  <tr> 
				<td align=right>Address Type</td>
				<td><strong><?php echo mdAddrGetAddressTypeString() ;?></strong></td>
			  </tr>
			<?php
			}		  
			if (mdAddrGetCongressionalDistrict()!="")
			{
			?>
			  <tr> 
				<td align=right>Representative, Party & District</td>
				<td><strong><?php echo mdAddrGetCongressionalDistrict();?></strong></td>
			  </tr>
			<?php
			}		  
			?>
			  <tr> 
				<td align=right>Time Zone</td>
				<td><strong><?php echo mdAddrGetTimeZone(); ?> </strong></td>
			  </tr>
			<?php
			if (trim(mdAddrGetLacs())!="")
			{
			?>
			  <tr> 
				<td align=right>LACS Status</td>
				<td><strong><?php echo mdAddrGetLacs() ;?></strong></td>
			  </tr>
			<?php
			}
			if (1) //(mdAddrGetZip() == "92688")
			{		  
			?>
			  <tr> 
				<td align=right>Build Number</td>
				<td><strong><?php echo mdAddrGetBuildNumber();?></strong></td>
			  </tr>
			  <tr> 
				<td align=right>Data Base Date</td>
				<td><strong><?php echo mdAddrGetDatabaseDate();?></strong></td>
			  </tr>
			<?php
			}
			
			
		}// end if status code
		else
		{
			switch (mdAddrGetErrorCode())
			{
				case "M":
					$errorStatus = "Multiple Matches";
					break;
				case "N":
					$errorStatus = "No Data Available For City";
					break;
				case "R":
					$errorStatus = "Range Error";
					break;
				case "T":
					$errorStatus = "Component Error";
					break;
				case "U":
					$errorStatus = "Unknown Street";
					break;
				case "X":
					$errorStatus = "Undeliverable Address";
					break;
				case "Z":
					$errorStatus = "Invalid ZIP Code";
					break;
				case "C":
					$errorStatus = "Canadian ZIP Code";
					break;
				case "D":
					$errorStatus = "Demo Mode Only";
					break;
				default:
					$errorStatus = mdAddrGetErrorString();
					break;
			}
			?>
			  <tr> 
				<td width="364" align=right>Address Error String</td>
				<td width="371" align=left><b><?php echo $errorStatus ;?></b></td>
			  </tr>
			<?php
		}
		?>
<?php
	 echo "</table>";
	}		
}	
?>

<?php
/* ***************** PARSE CHECK ******************
Using Parse Interface to parse address line
Methods Used: parse Method, parseNext
*************************************************** */
function parsecheck($company,$address,$city,$state,$zipcode)
{
	$cnt=0;
	if (strlen($address) == 0)
	{
		$errorstr = "Address Line is Blank";
	}
	else
	{
		mdParseCreate();

		//check parse/parseNext method 
//		$result = mdParseParse($address);
//		echo "Parse address = ".$result."\n";
	
		mdParseParse($address);

//		if ($result!=1)
//		{
//			$errorstr = "<b> Can not parse Adress </b>";
//			$cnt =0;
//		}
//		else
		{
			$errorstr = "Address Parse Result";
			$cnt = 1;
		}
	}
	//
	echo "<table border=\"1\" bgcolor=\"FFFFCC\" cellpadding=\"2\" width=\"754\" valgin=\"top\" align=\"center\">";
	echo "  <tr> ";
    echo "    <td bgcolor=\"33ff99\" align=\"center\" colspan=\"2\"><b>".$errorstr."</b></td>";
    echo "  </tr> ";
	
	if ($cnt==1)
	{
		while (mdParseParseNext()!=0)
		{
     	?>
			<tr bgcolor=33ff99> 
			<td align=right width="365"><b>Parse Try: </b></td>
				<td width="369"><b><?php echo $cnt ?></b></td>
			</tr>
			<tr> 
				<td align=right width="365">Range</td>
				<td><b><?php echo mdParseGetRange() ;?></b></td>
			</tr>
			<tr> 
				<td align=right>PreDirection</td>
				<td><b><?php echo mdParseGetPreDirection() ;?></b></td>
		  	</tr>
		  	<tr> 
				<td align=right>Street</td>
				<td><b><?php echo mdParseGetStreetName() ;?></b></td>
		  	</tr>
		  	<tr> 
				<td align=right>Post Direction</td>
				<td><b><?php echo mdParseGetPostDirection() ;?></b></td>
		  	</tr>
		  	<tr> 
				<td align=right>Suffix</td>
				<td><b><?php echo mdParseGetSuffix() ;?></b></td>
		  	</tr>
		  	<tr> 
				<td align=right>Suite Name</td>
				<td><b><?php echo mdParseGetSuiteName() ;?></b></td>
		  	</tr>
		  	<tr> 
				<td align=right>Suite Number</td>
				<td><b><?php echo mdParseGetSuiteNumber() ; ?></b></td>
		  	</tr>
		  	<!-------------------------------->
			<?php 
				mdParseLastLineParse(trim($city)); 
			?>
		  	<tr> 
				<td align=right>Zip</td>
				<td><b><?php echo mdParseGetZip() ; ?></b></td>
		  	</tr>
		  	<tr> 
				<td align=right>Plus4</td>
				<td><b><?php echo mdParseGetPlus4() ; ?></b></td>
		  	</tr>
		  	<tr> 
				<td align=right>City</td>
				<td><b><?php echo mdParseGetCity() ; ?></b></td>
		  	</tr>
		  	<tr> 
				<td align=right>State</td>
				<td><b><?php echo mdParseGetState() ; ?></b></td>
		  	</tr>
		  	<tr> 
				<td align=right>Private Mailbox Number</td>
				<td><b><?php echo mdParseGetPrivateMailboxNumber() ; ?></b></td>
		  	</tr>
		  	<tr> 
				<td align=right>Private Mailbox Name</td>
				<td><b><?php echo mdParseGetPrivateMailboxName() ; ?></b></td>
		  	</tr>
		  	<tr> 
				<td align=right>Garbage</td>
				<td><b><?php echo mdParseGetGarbage() ; ?></b></td>
		  	</tr>
			
		  <?php
		  	$cnt = $cnt+1;
		  } 
	}
	echo "</table>";
}
?>

<?php
/* ZIP CODE */
function checkzipcode($license,$datafiles,$id,$company,$address,$city,$state,$zipcode)
{
	//Create mdAddress Object
	mdZipCreate();
	//Set Master License String
	mdZipSetLicenseString($license);
	
	// Initialize
	mdZipInitialize($datafiles,$datafiles,"");
	switch ($id)
	{
		case 3: 
			checkcitiesinzip($company,$address,$city,$state,$zipcode);
			break;
		case 4: 
			checkzipsincity($company,$address,$city,$state,$zipcode);
			break;
		case 5:
			checkcitiesinstate($company,$address,$city,$state,$zipcode);
			break;
	}
}
/* ****************ZIPs in City ********************
Using ZipCodeData Interface to search for ZIPs in Provided City and State
Methods Used: FindZipInCity and FindZipInCityNext
*************************************************** */
function checkzipsincity($company,$address,$city,$state,$zipcode)
{
	$cnt = 0 ;
	$status="";
	if (strlen($city) == 0)
	{
		$status = "City Name Missing";
	}
	else
	{
		if (strlen($state) == 0)
		{
			$status = "2-letter State Abbreviation Missing";
		}
		else
		{
			if (strlen(trim($state)) != 2)
			{
				$status = "2-letter State Abbreviation Incorrect";
			}
		}
	}
	
	if ($status != "")
	{
		$cnt=0;
	}
	else
	{
		$citystate = trim(strtoupper($city)).", ".strtoupper($state);
		if (mdZipFindZipInCity($city,$state) != 1)
		{
			// Can not find city and states
			$status = "<b>".$citystate." NOT found </b>";
		}
		else
		{
			$status = "ZIPs in City = <b>".$citystate."</b>";
			$cnt=1;
		}
	}
	
	//make table
	echo "<table border=\"1\" bgcolor=\"FFFFCC\" cellpadding=\"2\" width=\"754\" valgin=\"top\" align=\"center\">";
    echo "  <tr> ";
    echo "    <td bgcolor=\"33ff99\" align=\"center\" colspan=\"3\"><b>".$status."</b></td>";
    echo "  </tr> ";
	
	if ($cnt==1)
	{
		echo" 	<tr bgcolor=\"33FF99\" align=\"center\"> ";
		echo" 	 	<td width=\"253\"><b>ZIP Code</b></td>";
		echo" 		<td width=\"249\"><b>ZIP Type</b></td>";
		echo" 		<td width=\"223\"><b>County</b></td>";
		echo" 	</tr>";
		///////////////////////////////////////////////////////////////////////////////////////////////
		
		echo"  <tr align=\"center\"> ";
		echo"   	<td><b>".mdZipGetZip()."</b></td>";
		echo"   	<td>".mdZipGetZipType()."</td>";
		echo"   	<td>".trim(mdZipGetCountyName())."</td>";
		echo"  </tr>";
		
		echo"  <tr align=\"center\"> ";
		echo"   	<td><b> </b></td>";
		echo"   	<td> (City) </td>";
		echo"   	<td>".mdZipGetCity()."</td>";
		echo"  </tr>";
		//
		echo"  <tr align=\"center\"> ";
		echo"   	<td><b> </b></td>";
		echo"   	<td> (City Abbrevation) </td>";
		echo"   	<td>".mdZipGetCityAbbreviation()."</td>";
		echo"  </tr>";
		//
		echo"  <tr align=\"center\"> ";
		echo"   	<td><b> </b></td>";
		echo"   	<td> (State) </td>";
		echo"   	<td>".mdZipGetState()."</td>";
		echo"  </tr>";
		//
		echo"  <tr align=\"center\"> ";
		echo"   	<td><b> </b></td>";
		echo"   	<td> (Zip Type) </td>";
		echo"   	<td>".mdZipGetZipType()."</td>";
		echo"  </tr>";
		//
		echo"  <tr align=\"center\"> ";
		echo"   	<td><b> </b></td>";
		echo"   	<td> (County Name)</td>";
		echo"   	<td>".trim(mdZipGetCountyName())."</td>";
		echo"  </tr>";
		//
		echo"  <tr align=\"center\"> ";
		echo"   	<td><b> </b></td>";
		echo"   	<td> (County Fips) </td>";
		echo"   	<td>".mdZipGetCountyFips()."</td>";
		echo"  </tr>";
		//
		echo"  <tr align=\"center\"> ";
		echo"   	<td><b> </b></td>";
		echo"   	<td> (Area Code) </td>";
		echo"   	<td>".mdZipGetAreaCode()."</td>";
		echo"  </tr>";
		//
		echo"  <tr align=\"center\"> ";
		echo"   	<td><b> </b></td>";
		echo"   	<td> (Longitude) </td>";
		echo"   	<td>".mdZipGetLongitude()."</td>";
		echo"  </tr>";
		//
		echo"  <tr align=\"center\"> ";
		echo"   	<td><b> </b></td>";
		echo"   	<td> (Latitude) </td>";
		echo"   	<td>".mdZipGetLatitude()."</td>";
		echo"  </tr>";
		//
		echo"  <tr align=\"center\"> ";
		echo"   	<td><b> </b></td>";
		echo"   	<td> (Time Zone) </td>";
		echo"   	<td>".mdZipGetTimeZone()."</td>";
		echo"  </tr>";
		//
		echo"  <tr align=\"center\"> ";
		echo"   	<td><b> </b></td>";
		echo"   	<td> (Time Zone Code) </td>";
		echo"   	<td>".mdZipGetTimeZoneCode()."</td>";
		echo"  </tr>";
		//
		echo"  <tr align=\"center\"> ";
		echo"   	<td><b> </b></td>";
		echo"   	<td> (Msa) </td>";
		echo"   	<td>".mdZipGetMsa()."</td>";
		echo"  </tr>";
		//
		echo"  <tr align=\"center\"> ";
		echo"   	<td><b> </b></td>";
		echo"   	<td> (Pmsa) </td>";
		echo"   	<td>".mdZipGetPmsa()."</td>";
		echo"  </tr>";
		//
		echo"  <tr align=\"center\"> ";
		echo"   	<td><b> </b></td>";
		echo"   	<td> (Facility Code) </td>";
		echo"   	<td>".mdZipGetFacilityCode()."</td>";
		echo"  </tr>";
		//
		echo"  <tr align=\"center\"> ";
		echo"   	<td><b> </b></td>";
		echo"   	<td> (Last Line Indicator) </td>";
		echo"   	<td>".mdZipGetLastLineIndicator()."</td>";
		echo"  </tr>";
		//
		echo"  <tr align=\"center\"> ";
		echo"   	<td><b> </b></td>";
		echo"   	<td> (Last Line Number) </td>";
		echo"   	<td>".mdZipGetLastLineNumber()."</td>";
		echo"  </tr>";
		//
		echo"  <tr align=\"center\"> ";
		echo"   	<td><b> </b></td>";
		echo"   	<td> (Preferred Last Line Number) </td>";
		echo"   	<td>".mdZipGetPreferredLastLineNumber()."</td>";
		echo"  </tr>";
		//
		echo"  <tr align=\"center\"> ";
		echo"   	<td><b> </b></td>";
		echo"   	<td> (Automation) </td>";
		echo"   	<td>".mdZipGetAutomation()."</td>";
		echo"  </tr>";
		
		///////////////////////////////////////////////////////////////////////////////////////////////
		while (mdZipFindZipInCityNext()==1)		
		{
			 echo"  <tr align=\"center\"> ";
			 echo"   	<td><b>".mdZipGetZip()."</b></td>";
			 echo"   	<td>".mdZipGetZipType()."</td>";
			 echo"   	<td>".trim(mdZipGetCountyName())."</td>";
			 echo"  </tr>";
		}  
	}
	
	//write last row
	if ($cnt==1)
	{
		echo"  <font size=\"0.5\">";
		echo"  <tr bgcolor=\"33FF99\" align=\"center\">";
		echo"  	 <td colspan=\"3\">ZIP Type: P=PO Box,  U=Unique, M=Military</td>";
		echo"  </tr>";
		echo"  </font>";
	}

	echo "</table>";
}
?>
<?php
/* ***************** Cities in ZIP ********************
Using ZipCodeData Interface to search for Cities in Provided ZIP
Methods Used: FindZip and FindZipNext
*************************************************** */
function checkcitiesinzip($company,$address,$city,$state,$zipcode)
{
	$cnt = 0 ;
	if ( strlen(trim($zipcode)) == 0)
	{
		$status = "Enter a 5-digit ZIP Code";
	}
	else
	{
		$result = mdZipFindZip($zipcode,0);
		if ($result!=1)
		{
			$status = "Invalid ZIP Code";
		}
		else // valid zip => process
		{
			$status = "Cities in ZIP = ".substr($zipcode,0,5);
			$cnt=1;
		}
	}
	
	echo "<table bgcolor=\"FFFFCC\" border=\"1\" cellpadding=\"2\" width=\"754\" valgin=\"top\" align=\"center\">";
	echo "<tr>";
	echo "	<td bgcolor=\"33FF99\" align=\"center\" colspan=\"3\"><b>".$status."</b></td>";
	echo "</tr>";
	if ($cnt==1)
	{
		echo "<font size=1>";
		do 
		{
			if (mdZipGetLastLineIndicator()=="L")
			{
				// LastLineIndicator="L" meaning City name is the official U.S. Postal Service name for the ZIP code
				echo"<tr align=\"center\"> ";
				echo"	<td width=\"207\">".$cnt."</td>";
				echo"	<td width=\"297\"><b>".trim(mdZipGetCity()) .", ".mdZipGetState()."</b></td>";
				echo"	<td width=\"221\">Preferred</td>";
  				echo" </tr>";
			}
			else
			{
				echo"<tr align=\"center\"> ";
				echo"	<td width=\"207\">".$cnt."</td>";
				echo"	<td width=\"297\">".trim(mdZipGetCity()) .", ".mdZipGetState()."</td>";
				echo"	<td width=\"221\">&nbsp;</td>";
  				echo" </tr>";
			}
			
			/////////////////////////////////////////////////////////////////////////////////////////////////
			echo"<tr align=\"center\"> ";
			echo"	<td width=\"207\"></td>";
			echo"	<td width=\"297\"><b> Zip = ".mdZipGetZip()."</b></td>";
			echo"	<td width=\"221\">&nbsp;</td>";
  			echo" </tr>";
			//
			echo"<tr align=\"center\"> ";
			echo"	<td width=\"207\"></td>";
			echo"	<td width=\"297\"><b> ZipType = ".mdZipGetZipType()."</b></td>";
			echo"	<td width=\"221\">&nbsp;</td>";
  			echo" </tr>";
			//
			echo"<tr align=\"center\"> ";
			echo"	<td width=\"207\"></td>";
			echo"	<td width=\"297\"><b> County Name = ".mdZipGetCountyName()."</b></td>";
			echo"	<td width=\"221\">&nbsp;</td>";
  			echo" </tr>";
			//
			echo"<tr align=\"center\"> ";
			echo"	<td width=\"207\"></td>";
			echo"	<td width=\"297\"><b> Fips = ".mdZipGetCountyFips()."</b></td>";
			echo"	<td width=\"221\">&nbsp;</td>";
  			echo" </tr>";
			//
			echo"<tr align=\"center\"> ";
			echo"	<td width=\"207\"></td>";
			echo"	<td width=\"297\"><b> Area Code = ".mdZipGetAreaCode()."</b></td>";
			echo"	<td width=\"221\">&nbsp;</td>";
  			echo" </tr>";
			//
			echo"<tr align=\"center\"> ";
			echo"	<td width=\"207\"></td>";
			echo"	<td width=\"297\"><b> Longitude = ".mdZipGetLongitude()."</b></td>";
			echo"	<td width=\"221\">&nbsp;</td>";
  			echo" </tr>";
			//
			echo"<tr align=\"center\"> ";
			echo"	<td width=\"207\"></td>";
			echo"	<td width=\"297\"><b> Latitude = ".mdZipGetLatitude()."</b></td>";
			echo"	<td width=\"221\">&nbsp;</td>";
  			echo" </tr>";
			//
			echo"<tr align=\"center\"> ";
			echo"	<td width=\"207\"></td>";
			echo"	<td width=\"297\"><b> Time Zone = ".mdZipGetTimeZone()."</b></td>";
			echo"	<td width=\"221\">&nbsp;</td>";
  			echo" </tr>";
			//
			echo"<tr align=\"center\"> ";
			echo"	<td width=\"207\"></td>";
			echo"	<td width=\"297\"><b> Time Zone Code = ".mdZipGetTimeZoneCode()."</b></td>";
			echo"	<td width=\"221\">&nbsp;</td>";
  			echo" </tr>";
			//
			echo"<tr align=\"center\"> ";
			echo"	<td width=\"207\"></td>";
			echo"	<td width=\"297\"><b> Msa = ".mdZipGetMsa()."</b></td>";
			echo"	<td width=\"221\">&nbsp;</td>";
  			echo" </tr>";
			//
			echo"<tr align=\"center\"> ";
			echo"	<td width=\"207\"></td>";
			echo"	<td width=\"297\"><b> Pmsa = ".mdZipGetPmsa()."</b></td>";
			echo"	<td width=\"221\">&nbsp;</td>";
  			echo" </tr>";
			//
			echo"<tr align=\"center\"> ";
			echo"	<td width=\"207\"></td>";
			echo"	<td width=\"297\"><b>Facility Code = ".mdZipGetFacilityCode()."</b></td>";
			echo"	<td width=\"221\">&nbsp;</td>";
  			echo" </tr>";
			//
			echo"<tr align=\"center\"> ";
			echo"	<td width=\"207\"></td>";
			echo"	<td width=\"297\"><b> Last Line Indicator = ".mdZipGetLastLineIndicator()."</b></td>";
			echo"	<td width=\"221\">&nbsp;</td>";
  			echo" </tr>";
			//
			echo"<tr align=\"center\"> ";
			echo"	<td width=\"207\"></td>";
			echo"	<td width=\"297\"><b> Last Line Number = ".mdZipGetLastLineNumber()."</b></td>";
			echo"	<td width=\"221\">&nbsp;</td>";
  			echo" </tr>";
			//
			echo"<tr align=\"center\"> ";
			echo"	<td width=\"207\"></td>";
			echo"	<td width=\"297\"><b> Preferred Last Line Number = ".mdZipGetPreferredLastLineNumber()."</b></td>";
			echo"	<td width=\"221\">&nbsp;</td>";
  			echo" </tr>";
			//
			echo"<tr align=\"center\"> ";
			echo"	<td width=\"207\"></td>";
			echo"	<td width=\"297\"><b> Automation = ".mdZipGetAutomation()."</b></td>";
			echo"	<td width=\"221\">&nbsp;</td>";
  			echo" </tr>";
									
			/////////////////////////////////////////////////////////////////////////////////////////////////
			
			$cnt = $cnt +1;				
		} while(mdZipFindZipNext()==1);
	}

	echo "</table>";

}
?>
<?php
/* **************** Cities in State *******************
Using ZipCodeData Interface to search for Cities in Provided State
Interface Used: FindCityInState and FindCityInStateNext
*************************************************** */
function checkcitiesinstate($company,$address,$city,$state,$zipcode)
{
	$cnt = 0 ;
	// Check for States and City
	if ($state == "")
	{
		$status = "State Line is Blank";
	}
	else
	{
		// Find city in States
		$result = mdZipFindCityInState($city,$state);
		
		if ($result!=1)
		{
			$status = "No Math Found";
		}
		else
		{
			$status = "Cities in State: ".$state;
			$cnt = 1;
		}
	}
	
	echo "<table bgcolor=\"FFFFCC\" border=\"1\" cellpadding=\"2\" width=\"754\" valgin=\"top\" align=\"center\">";
	echo "	<tr>";
	echo "		<td bgcolor=\"33FF99\" align=\"center\" colspan=\"4\"><b>".$status."</b></td>";
	echo "	</tr>";
	
	if ($cnt==1)
	{
		echo" <tr bgcolor=\"33FF99\" align=\"center\">";
		echo"	<td width=\"160\"><b>Count</b></td>";
		echo"	<td width=\"188\"><b>City</b></td>";
		echo"	<td width=\"191\"><b>States</b></td>";
		echo"	<td width=\"178\"><b> Preferred</b></td>";
		echo"</tr>";
		
		//////////////////////////////////////////10/28/04//////////////////////////////////////////
		echo"<tr align=\"center\">";
		echo"	<td>".$cnt."</td>";
		echo"	<td>".mdZipGetCity()."</td>";
		echo"	<td>".mdZipGetState()."</td>";
		echo"	<td><b> Preferred</b></td>";
		echo"</tr>";
		//
		echo"<tr align=\"center\">";
		echo"	<td> </td>";
		echo"	<td> (Zip) </td>";
		echo"	<td>".mdZipGetZip()."</td>";
		echo"	<td><b> </b></td>";
		echo"</tr>";
		//
		echo"<tr align=\"center\">";
		echo"	<td> </td>";
		echo"	<td> (City Abbr) </td>";
		echo"	<td>".mdZipGetCityAbbreviation()."</td>";
		echo"	<td><b> </b></td>";
		echo"</tr>";
		//
		echo"<tr align=\"center\">";
		echo"	<td> </td>";
		echo"	<td> (Zip Type) </td>";
		echo"	<td>".mdZipGetZipType()."</td>";
		echo"	<td><b> </b></td>";
		echo"</tr>";
		//
		echo"<tr align=\"center\">";
		echo"	<td> </td>";
		echo"	<td> (County) </td>";
		echo"	<td>".mdZipGetCountyName()."</td>";
		echo"	<td><b> </b></td>";
		echo"</tr>";
		//
		echo"<tr align=\"center\">";
		echo"	<td> </td>";
		echo"	<td> (County Fips) </td>";
		echo"	<td>".mdZipGetCountyFips()."</td>";
		echo"	<td><b> </b></td>";
		echo"</tr>";
		//
		echo"<tr align=\"center\">";
		echo"	<td> </td>";
		echo"	<td> (Area Code) </td>";
		echo"	<td>".mdZipGetAreaCode()."</td>";
		echo"	<td><b> </b></td>";
		echo"</tr>";
		//
		echo"<tr align=\"center\">";
		echo"	<td> </td>";
		echo"	<td> (Longitude) </td>";
		echo"	<td>".mdZipGetLongitude()."</td>";
		echo"	<td><b> </b></td>";
		echo"</tr>";
		//
		echo"<tr align=\"center\">";
		echo"	<td> </td>";
		echo"	<td> (Latitude) </td>";
		echo"	<td>".mdZipGetLatitude()."</td>";
		echo"	<td><b> </b></td>";
		echo"</tr>";
		//
		echo"<tr align=\"center\">";
		echo"	<td> </td>";
		echo"	<td> (TimeZone) </td>";
		echo"	<td>".mdZipGetTimeZone()."</td>";
		echo"	<td><b> </b></td>";
		echo"</tr>";
		//
		echo"<tr align=\"center\">";
		echo"	<td> </td>";
		echo"	<td> (Zone Code) </td>";
		echo"	<td>".mdZipGetTimeZoneCode()."</td>";
		echo"	<td><b> </b></td>";
		echo"</tr>";
		//
		echo"<tr align=\"center\">";
		echo"	<td> </td>";
		echo"	<td> (Msa) </td>";
		echo"	<td>".mdZipGetMsa()."</td>";
		echo"	<td><b> </b></td>";
		echo"</tr>";
		//
		echo"<tr align=\"center\">";
		echo"	<td> </td>";
		echo"	<td> (PMSA) </td>";
		echo"	<td>".mdZipGetPmsa()."</td>";
		echo"	<td><b> </b></td>";
		echo"</tr>";
		//
		echo"<tr align=\"center\">";
		echo"	<td> </td>";
		echo"	<td> (Last Line Indicator) </td>";
		echo"	<td>".mdZipGetLastLineIndicator()."</td>";
		echo"	<td><b> </b></td>";
		echo"</tr>";
		//
		echo"<tr align=\"center\">";
		echo"	<td> </td>";
		echo"	<td> (Last Line Number) </td>";
		echo"	<td>".mdZipGetLastLineNumber()."</td>";
		echo"	<td><b> </b></td>";
		echo"</tr>";
		//
		echo"<tr align=\"center\">";
		echo"	<td> </td>";
		echo"	<td> (Preferred Last Line) </td>";
		echo"	<td>".mdZipGetPreferredLastLineNumber()."</td>";
		echo"	<td><b> </b></td>";
		echo"</tr>";
		//
		echo"<tr align=\"center\">";
		echo"	<td> </td>";
		echo"	<td> (Automation) </td>";
		echo"	<td>".mdZipGetAutomation()."</td>";
		echo"	<td><b> </b></td>";
		echo"</tr>";
		//
		
		/////////////////////////////////////////////////////////////////////////////////////////////////
		$cnt = $cnt + 1;
		while (mdZipFindCityInStateNext()==1)
		{
			echo"<tr align=\"center\">";
			echo"	<td>".$cnt."</td>";
			echo"	<td>".mdZipGetCity()."</td>";
			echo"	<td>".mdZipGetState()."</td>";
			echo"	<td><b> Preferred</b></td>";
			echo"</tr>";
			$cnt = $cnt+1;
		}
	}
	
	echo "</table>";	  
}
?>

<?php
/* ************* STREET DATA **********************
Using StreetData Interface, Parse Interface to search for Street in Given ZIP
Methods Used: Parse, FindStreet and FindStreetNext
*************************************************** */
function checkstreet($license,$datafiles,$company,$address,$city,$state,$zipcode)
{
	$cnt=0;
	$result=-1;
	// Check zipcode
	if (trim($zipcode) == "")
	{
		$status = "ZIP code is missing";
	}
	else
	{
		//Create Street Object
		mdStreetCreate();

		//Set Master License String
		mdStreetSetLicenseString($license);
	
		// Initialize
		mdStreetInitialize($datafiles,$datafiles,"");
		
		//parse
		mdParseCreate();
	
		mdParseParse($address);
		// Get Street name from objparse, use * for Wildcard
		$streetname = mdParseGetStreetName()."*";
		// Now start street search method, 0 is for all ranges, 1 is for in range
		$result = mdStreetFindStreet($streetname,$zipcode,0);
		
		if ($result!=1)
		{
			$status = "<b>Can not find  ".str_replace("*","",$streetname)." in ZIP ".$zipcode."</b>";
		}
		else
		{
			$status = "<b>Search Street: ".str_replace("*","",$streetname)." From ZIP: ".$zipcode."</b>";
		}
		
	}
	
	echo"	<table bgcolor=\"FFFFCC\" border=\"1\" cellpadding=\"2\" width=\"756\" valgin=\"top\" align=\"center\">";
	echo"		<tr>";
	echo"			<td bgcolor=\"33FF99\" align=\"center\" colspan=\"23\"><b>".$status."</b></td>";
	echo"		</tr>";
	
	if ($result==1)
	{
		$cnt = 1;
		// Print column title
		echo"	<tr bgcolor= \"33FF99\">";
		echo "		<td width=\"37\"><b>priLo</b></td>";
		echo"		<td width=\"35\"><b>priHi</b></td>";
		echo"		<td width=\"41\"><b>priOE</b></td>";
		echo"		<td width=\"46\"><b>preDir</b></td>";
		echo"		<td width=\"74\"><b>streetName</b></td>";
		echo"		<td width=\"38\"><b>suffix</b></td>";
		echo"		<td width=\"52\"><b>postDir</b></td>";
		echo"		<td width=\"62\"><b>steName</b></td>";
		echo"		<td width=\"39\"><b>steLo</b></td>";
		echo"		<td width=\"37\"><b>steHi</b></td>";
		echo"		<td width=\"46\"><b>ZIP</b></td>";
		echo"		<td width=\"55\"><b>plus4Lo</b></td>";
		echo"		<td width=\"86\"><b>company</b></td>";
		echo"		<td width=\"86\"><b>STE OE</b></td>";
		echo"		<td width=\"86\"><b>CRRT</b></td>";
		echo"		<td width=\"86\"><b>FIPS</b></td>";
		echo"		<td width=\"86\"><b>AddrType</b></td>";
		echo"		<td width=\"86\"><b>LACS</b></td>";
		echo"		<td width=\"86\"><b>Urban</b></td>";
		echo"		<td width=\"86\"><b>LastLine</b></td>";
		echo"		<td width=\"86\"><b>Congressional District</b></td>";
		echo"		<td width=\"86\"><b>Base Alt Indicator</b></td>";
		echo"		<td width=\"86\"><b>plus4Hi</b></td>";
		echo"	</tr>";

			
		 do
		{
			echo"	<tr>";
			echo"		<td>".intval(mdStreetGetPrimaryRangeLow())."&nbsp;</td>";
			echo"		<td>".intval(mdStreetGetPrimaryRangeHigh())."&nbsp;</td>";
			echo"		<td>".mdStreetGetPrimaryRangeOddEven()."&nbsp;</td>";
			echo"		<td>".mdStreetGetPreDirection()."&nbsp;</td>";
			echo"		<td>".mdStreetGetStreetName()."&nbsp;</td>";
			echo"		<td>".mdStreetGetSuffix()."&nbsp;</td>";
			echo"		<td>".mdStreetGetPostDirection()."&nbsp;</td>";
			echo"		<td>".mdStreetGetSuiteName()."&nbsp;</td>";
			echo"		<td>".mdStreetGetSuiteRangeLow()."&nbsp;</td>";
			echo"		<td>".mdStreetGetSuiteRangeHigh()."&nbsp;</td>";
			echo"		<td>".mdStreetGetZip()."&nbsp;</td>";
			echo"		<td>".mdStreetGetPlus4Low()."&nbsp;</td>";
			
			echo"		<td>".mdStreetGetCompany()."&nbsp;</td>";
			echo"		<td>".mdStreetGetSuiteRangeOddEven()."&nbsp;</td>";
			echo"		<td>".mdStreetGetCarrierRoute()."&nbsp;</td>";
			echo"		<td>".mdStreetGetCountyFips()."&nbsp;</td>";
			echo"		<td>".mdStreetGetAddressType()."&nbsp;</td>";
			echo"		<td>".mdStreetGetLacsIndicator()."&nbsp;</td>";
			echo"		<td>".mdStreetGetUrbanizationCode()."&nbsp;</td>";
			echo"		<td>".mdStreetGetLastLineNumber()."&nbsp;</td>";
			echo"		<td>".mdStreetGetCongressionalDistrict()."&nbsp;</td>";
			echo"		<td>".mdStreetGetBaseAlternateIndicator()."&nbsp;</td>";
			
			echo"		<td>".mdStreetGetPlus4High()."&nbsp;</td>";
			echo"	</tr>";
		}while (mdStreetFindStreetNext()==1);

		$cnt = $cnt + 1;
	}
	
	echo"	</table>";
}
?>
<body>
<script language="javascript">
	function setaction(value)
	{
		document.forms[0].id.value = value;
		document.forms[0].submit();
	}
</script>
<form method="post" action="AddressObjectPHPSample.php">
  <table width="77%" border="0" cellspacing="0" cellpadding="0" align="center">
    <tr> 
      <td width="13%">&nbsp;</td>
      <td width="32%">&nbsp;</td>
      <td width="19%">&nbsp;</td>
      <td width="36%">&nbsp;</td>
    </tr>
    <tr> 
      <td colspan="4"><table width="753" cellspacing=0 border=1 bgcolor="#F7F7F7">
          <tr> 
            <td width="747"><font color="#ce0000" size="+2">Address Object Demo</font></td>
          </tr>
        </table></td>
    </tr>
    <tr> 
      <td colspan="4"> Enter any U.S. address and then click on Verify Address. 
        It requires an address and a ZIP Code or a City and State <br>
        combination. Parse Address displays how an address is split into components. 
        Cities in ZIP displays all the city names <br>
        associated with a ZIP Code.</td>
    </tr>
    <tr> 
      <td colspan="4"><table width="752" cellspacing=0 border=0 bgcolor="#F7F7F7">
          <tr> 
            <td width="750"><font color="#ce0000" size="+1">Input</font></td>
          </tr>
        </table></td>
    </tr>
    <tr> 
      <td colspan="4"> </td>
    </tr>
    <tr> 
      <td align="right">Company &nbsp;</td>
      <td><input type="text" name="company" value="<?php echo $company ?>" size="30"></td>
      <td><input type="button" name="verifyaddress" onclick = "setaction('1')" value="  Verify Address  "></td>
      <td> << AddressCheck</td>
    </tr>
    <tr> 
      <td align="right" >Address&nbsp;</td>
      <td><input type="text" name="address" value="<?php echo $address ?>" size="30"></td>
      <td><input type="button" name="parseaddress" onclick = "setaction('2')" value="  Parse Address  "></td>
      <td> << Parse</td>
    </tr>
    <tr> 
      <td align="right" >City &nbsp;</td>
      <td><input type="text" name="city" value="<?php echo $city ?>" size="20"></td>
      <td><input type="button" name="citiesinzip" onclick = "setaction('3')" value="  Cities in ZIP  "></td>
      <td> << ZIPCodeData</td>
    </tr>
    <tr> 
      <td align="right">State &nbsp;</td>
      <td><input type="text" name="state" value="<?php echo $state ?>" size="10"></td>
      <td><input type="button" name="zipsincity" onclick = "setaction('4')" value="  ZIPs in City  "></td>
      <td> << ZIPCodeData</td>
    </tr>
    <tr> 
      <td align="right">ZIP Code &nbsp;</td>
      <td><input type="text" name="zipcode" value="<?php echo $zipcode ?>" size="20"></td>
      <td><input type="button" name="citiesinstate" onclick = "setaction('5')" value="  Cities in State  "></td>
      <td> << ZIPCodeData, use * for wildcard</td>
    </tr>
    <tr> 
      <td>&nbsp;</td>
      <td>&nbsp;</td>
      <td><input type="button" name="findstreet" onclick = "setaction('6')" value="  Find Street  "></td>
      <td> << StreetData</td>
    </tr>
    <tr> 
      <td>&nbsp;</td>
      <td>&nbsp;</td>
      <td><input type="button" name="cleardisplay" onclick = "setaction('7')" value="  Clear Display  "></td>
      <td>&nbsp;</td>
    </tr>
    <tr> 
      <td>&nbsp;</td>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
    </tr>
    <tr> 
      <td>&nbsp;</td>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
    </tr>
    <?php if ($id!=0) {writeOutputLine();}?>
    <tr> 
      <td colspan="4">
	  <?php 
		switch ($id)
		{ 
			case 1:
				checkadress($license,$datafiles,$company,$address,$city,$state,$zipcode);
				break;
			case 2:
	  			parsecheck($company,$address,$city,$state,$zipcode);
				break;
			case 3:
			case 4:
			case 5:
				checkzipcode($license,$datafiles,$id,$company,$address,$city,$state,$zipcode);
				break;
			case 6:
	  			checkstreet($license,$datafiles,$company,$address,$city,$state,$zipcode);
				break;
			default:
				break;
		} 
	  ?> 
	  </td>
    </tr>
    <tr> 
      <td>&nbsp;</td>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
    </tr>
  </table>
<input type="hidden" name="id" value="0">
</form>
</body>
</html>


